
#ifndef LLF_AESCCM_H
#define LLF_AESCCM_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "CRYS_AESCCM.h"
#include "LLF_AESCCM_error.h"
#include "LLF_AES.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  25 Sept. 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version LLF_AESCCM.h#1:incl:1
   *  \author R.Levin
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines ******************************/

/* Defining the minimum number of blocks that will activate a DMA operation.
   Less from this number the AES will work on the direct mode, since the DMA 
   is not efficient in this case */  
#define LLF_AESCCM_MIN_AES_BLOCKS_FOR_DMA_OPERATION  1//500000



/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************ Structs  ******************************/

/************************ Public Variables **********************/

/************************ Public Functions ******************************/


/*********************************************************************************************/
/**
* @brief The LLF_AESCCM_BlockAdata function processes the AESCCM-MAC operation on block of Additional data.
*         
* @param[in] WorkingContextID_ptr - The AESCCM context allocated by the CCM.
* @param[in] DataIn_ptr -  The pointer to the input buffer passed by the user.
* @param[in] DataInSize -  The size of the buffer the user shall operate on.

* @return CRYSError_t - On success CRYS_OK is returned, on failure a value defined in LLF_AESCCM_error.h
*/

CRYSError_t  LLF_AESCCM_BlockAdata( AESCCM_Context_t    *WorkingContextID_ptr,    
									DxUint8_t           *DataIn_ptr,                     
									DxUint32_t           DataInSize );

/*********************************************************************************************/
/**
* @brief The LLF_AESCCM_BlockTextData function processes the AESCCM-MAC operation on block of Additional data.
*         
* @param[in] WorkingContextID_ptr - The AESCCM context allocated by the CCM.
* @param[in] DataIn_ptr -  The pointer to the input buffer passed by the user.
* @param[in] DataInSize -  The size of the buffer the user shall operate on.
* @param[in] DataOut_ptr - The pointer to the output buffer passed by the user.

* @return CRYSError_t - On success CRYS_OK is returned, on failure a value defined in LLF_AESCCM_error.h
*/

CRYSError_t  LLF_AESCCM_BlockTextData( 
									AESCCM_Context_t    *WorkingContextID_ptr,
									DxUint8_t           *DataIn_ptr,
									DxUint32_t           DataInSize,
									DxUint8_t           *DataOut_ptr);


/*********************************************************************************************/
/**
* @brief The LLF_AESCCM_BlockLastTextData function processes the AESCCM-MAC operation on block of Additional data.
*         
* @param[in] WorkingContextID_ptr - The AESCCM context allocated by the CCM.
* @param[in] DataIn_ptr -  The pointer to the input buffer passed by the user.
* @param[in] DataInSize -  The size of the buffer the user shall operate on.
* @param[in] DataOut_ptr - The pointer to the output buffer passed by the user.

* @return CRYSError_t - On success CRYS_OK is returned, on failure a value defined in LLF_AESCCM_error.h
*/

CRYSError_t  LLF_AESCCM_BlockLastTextData( 
										AESCCM_Context_t    *WorkingContextID_ptr,
										DxUint8_t           *DataIn_ptr,
										DxUint32_t           DataInSize,
							    		DxUint8_t           *DataOut_ptr,
									    DxUint32_t           DataOutSize );
									    
/***********************************************************************************************/
/**
 * @brief The LLF_AESCCM_SEP_Block function operates the AES engine from the SEP in multi LLI mode. 
 *         
 *        1. The function gets a semaphore to protect the access to the hardware 
 *           from any other process the semaphores name: "crypto hardware busy"
 *        2. The function calls a VOS system call to map the registers physical base address 
 *           to the registers virtual address.
 *        3. The function calls the LLF_AES_BlockInit to initialize the AES hardware.
 *        4. According to operation mode the function calls the LLF_AES_BlockEcbCbcCtrModesSepMLLI or 
 *           LLF_AES_BlockMacModesSepMLLI function to execute the AES operation on LLI DMA mode.
 *        5. The function calls the LLF_AES_BlockFinish function to execute the last block and to save 
 *           the IV temporary values for the next block operation and to shut down the hardware machine.
 *        6. The function calls a VOS system call to un map the registers virtual address mapping.
 *        7. Release the "crypto hardware busy" semaphore acquired in paragraph 1.
 *        8. Exits the function.
 *
 *
 * @param[in] WorkingContextID_ptr - The AES context allocated by the CCM
 * @param[in] DataInLliTab_ptr - The pointer to the buffer of LLI table, containing pointers and sizes of
 *                         chuncks of input data block. The table need to be aligned and placed in SEP SRAM.
 * @param[in] InLliTabSize - The size of the input LLI table in words.
 * @param[in] DataOutLliTab_ptr - The pointer to the buffer of LLI table, containing pointers and sizes of
 *                         chuncks of buffer for output result data from AES. The table need to be 
 *                         aligned and placed in SEP SRAM.
 * @param[in] OutLliTabSize - The size of the output LLI table in words.
 * @param[in] DataInSize  - Size of input data block in bytes. 
 * 
 * @return CRYSError_t - On success CRYS_OK is returned, on failure a
 *                        value MODULE_* as defined in ...
 *
 *  NOTE: Assumed that all parameters are right passed and DataInSize = sum of all data chunck sizes 
 *        in the table 
 */

  CRYSError_t  LLF_AESCCM_SEP_Block( 
                                  AESCCM_Context_t  *WorkingContextID_ptr,    
			                      DxUint32_t        *DataInLliTab_ptr,        
			                      DxUint32_t         InLliTabSize,         
			                      DxUint32_t        *DataOutLliTab_ptr,
			                      DxUint32_t         OutLliTabSize,
			                      DxUint32_t         DataInSize );     
									    


#ifdef __cplusplus
}
#endif

#endif


